#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_BloodType : BaseTest 
	{
		
		private DataTable _dtBloodType;
		private BOL.BloodType _tstBT; 
		private string _bloodTypeCode;

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtBloodType = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodType",  true);

				this._bloodTypeCode = this._dtBloodType.Rows[0][TABLES.BloodType.BloodTypeCode].ToString();

				this.RefreshData = false;
			}

			this._tstBT = new BOL.BloodType(this._bloodTypeCode);
		}

		[Test]
		public void Ctor_String_Pass()
		{
			BOL.BloodType tmpBT = new BOL.BloodType(this._bloodTypeCode);
			
			Assert.IsNotNull(tmpBT);
			Assert.IsTrue(tmpBT.BloodTypeCode == this._bloodTypeCode);
			Assert.IsTrue(tmpBT.BloodTypeText == this._dtBloodType.Rows[0][TABLES.BloodType.BloodTypeText].ToString());
		}

		[Test]
        [ExpectedException(typeof(Common.DataAccessLayerException))]
		public void Ctor_String_Fail()
		{
			BOL.BloodType tmpBT = new BOL.BloodType("Mmmmmmm Sprinkles");
		}

		[Test]
		public void BloodTypeCode_Pass()
		{
			Assert.IsTrue(this._tstBT.BloodTypeCode == this._bloodTypeCode);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void BloodTypeCode_Fail()
		{
		}

		[Test]
		public void BloodTypeText_Pass()
		{
			Assert.IsTrue(this._tstBT.BloodTypeText == this._dtBloodType.Rows[0][TABLES.BloodType.BloodTypeText].ToString());
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void BloodTypeText_Fail()
		{
		}


		[Test]
		public void SortColumn_Pass()
		{
			short tstValue = (short)this._dtBloodType.Rows[0][TABLES.BloodType.SortColumn];

			Assert.IsTrue(this._tstBT.SortColumn == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void SortColumn_Fail()
		{
		}

		[Test]
		public void LastUpdateDate_Pass()
		{
			System.DateTime tstValue = (System.DateTime)this._dtBloodType.Rows[0][TABLES.BloodType.LastUpdateDate];

			Assert.IsTrue(this._tstBT.LastUpdateDate == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LastUpdateDate_Fail()
		{
		}

		[Test]
		public void LastUpdateUser_Pass()
		{
			string tstValue = this._dtBloodType.Rows[0][TABLES.BloodType.LastUpdateUser].ToString();

			Assert.IsTrue(this._tstBT.LastUpdateUser == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LastUpdateUser_Fail()
		{
		}

		[Test]
		public void RowVersion_Pass()
		{
			byte[] tstValue = (byte[])this._dtBloodType.Rows[0][TABLES.BloodType.RowVersion];

			Assert.IsTrue(this._tstBT.RowVersion.Length == tstValue.Length);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void RowVersion_Fail()
		{
		}

		[Test]
		public void GetBloodType_Pass()
		{
			BOL.BloodType tmpBT = BOL.BloodType.GetBloodType(this._bloodTypeCode);

			Assert.IsTrue(tmpBT.BloodTypeCode == this._tstBT.BloodTypeCode);
			Assert.IsTrue(tmpBT.BloodTypeText == this._tstBT.BloodTypeText);
			Assert.IsTrue(tmpBT.SortColumn == this._tstBT.SortColumn);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetBloodType_Fail()
		{
		}


	}
}
#endif


